#pragma rtGlobals=1		// Use modern global access method.

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												HISTO MOMENTA
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    
Proc Histo_Momenta(particle, weight,pmin,pmax,threshold,nbins)
	string particle, weight
	variable pmin, pmax,threshold,nbins
	
	variable WaveSize
	
	Silent 1; PauseUpdate;
	WaveSize=numpnts($("x_"+particle))
	make/O/D/N=(Wavesize) dummy
	
	if (cmpstr(weight,"")==0) 
		dummy=1
	else
		dummy=$(weight)
	endif
		
 	// momenta	
	hist1 $("px_"+particle),dummy,(nbins),(pmin),(pmax),0,0,0
       hist1 $("py_"+particle),dummy,(nbins),(pmin),(pmax),0,0,0
       hist1 $("pz_"+particle),dummy,(nbins),(pmin),(pmax),0,0,0	
     	dummy=abs($("pz_"+particle))<threshold   
     	if (cmpstr(weight,"")!=0) 
		dummy*=$(weight)
	endif
	hist2 $("px_"+particle),$("py_"+particle),dummy,(nbins),(nbins),(pmin),(pmax),(pmin),(pmax),0,0,0
     	dummy=abs($("px_"+particle))<threshold  
         if (cmpstr(weight,"")!=0) 
		dummy*=$(weight)
	endif
	hist2 $("pz_"+particle),$("py_"+particle),dummy,(nbins),(nbins),(pmin),(pmax),(pmin),(pmax),0,0,0
	dummy=abs($("py_"+particle))<threshold
	 if (cmpstr(weight,"")!=0) 
		dummy*=$(weight)
	endif
	hist2 $("pz_"+particle),$("px_"+particle),dummy,(nbins),(nbins),(pmin),(pmax),(pmin),(pmax),0,0,0
	killwaves/z dummy
End

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												HISTO ANGLE & ENERGY
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    

Proc Histo_AngleEnergy(particle, weight, emin,emax,nbins)
    	String particle,weight
    	variable emin=0,emax=40,nbins=40

	variable WaveSize,wf
	
	Silent 1; PauseUpdate;
	
	WaveSize=numpnts($("x_"+particle))
	make/O/D/N=(Wavesize) dummy
	dummy=($("e_"+particle)>emin)*($("e_"+particle)<emax)
	if (cmpstr(weight,"")!=0) 
		dummy*=$(weight)
    	endif
    	
      hist1 $("thet_"+particle),dummy,(nbins),00,3.2,0,0,0,0   
      hist1 $("phi_"+particle),dummy,(nbins),-3.2,3.2,0
      hist2 $("thet_"+particle),$("phi_"+particle),dummy,(nbins),(nbins),0,3.2,-3.2,3.2,0,0,0,0      
      hist1 $("dvthet_"+particle), dummy,(nbins),0,3.2,0,0,0,0   
      hist1 $("dvphi_"+particle), dummy,(nbins),-3.2,3.2,0,0,0,0   
      hist2 $("dvthet_"+particle),$("dvphi_"+particle),dummy,(nbins),(nbins),0,3.2,-3.2,3.2,0,0,0,0         
	hist1 $("E_"+particle),dummy,(nbins),(emin),(emax),0,0,0,0   
 	hist1 $("Elong_"+particle),dummy,(nbins),(emin),(emax),0,0,0,0 
 	hist1 $("Etrans_"+particle),dummy,(nbins),(emin),(emax),0,0,0,0  	  
       hist2 $("Elong_"+particle),$("Etrans_"+particle),dummy,(nbins),(nbins),(emin),(emax),(emin),(emax),0,0,0,0  
	killwaves/z dummy

End

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												HISTO CORRELATION
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    
Proc Histo_Correlation(particle1,particle2, weight,E1,dE1,E2,dE2,nbins)
	string particle1,particle2,weight
    	variable E1=0,dE1=40,E2=0,dE2=40,nbins=40
    
	variable WaveSize,wf,x0,dx
	Silent 1; PauseUpdate;
	
	WaveSize=numpnts($("x_"+particle1))
	make/O/D/N=(Wavesize) dummy
	dummy=($("e_"+particle1)>e1-dE1)*($("e_"+particle1)<E1+dE1)*($("e_"+particle2)>E2-dE2)*($("e_"+particle2)<E2+dE2)

	if (cmpstr(weight,"")!=0) 
		dummy*=$(weight)
    	endif
    	    	
      hist1 $("thet_"+particle1+particle2),dummy,(nbins),0,3.14,0
      hist2 $("thet_"+particle1),$("thet_"+particle2),dummy,(nbins),(nbins),0,3.14,0,3.14,0,0,0,0      
      hist2 $("phi_"+particle1),$("phi_"+particle2),dummy,(nbins),(nbins),-3.14,3.14,-3.14,3.14,0,0,0,0      
	hist1 $("Etot_"+particle1+particle2),dummy,(nbins),(0),(E2+E1+dE1+dE2),0
	hist2 $("E_"+particle2),$("E_"+particle1), dummy,(nbins),(nbins),(E1-dE1),(E1+dE1),(E2-dE2),(E2+dE2),0,0,0,0

	killwaves/z dummy
	
	ponder1D($("Hist_thet_"+particle1+particle2))
End

